package gov.va.med.mhv.admin.web.validator;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "basicSearchIPAValidator")
public class BasicSearchIPAValidator implements Validator {

	private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");

	/*
	 * private static final Pattern emailPattern = Pattern
	 * .compile("^[_A-Za-z0-9-]+(\\." +
	 * "[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*" +
	 * "(\\.[A-Za-z]{2,})$");
	 */
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String firstPlusFour = null;
		String ssnThree = null;
		String ssnTwo = null;
		String ssnFour = null;
		String firstName = null;
		String middleName = null;
		String lastName = null;
		Date birthDate = null;
		String mhvId = null;
		String email = null;
		Matcher matcher = null;

		HtmlInputText firstPlusFourValue = (HtmlInputText) component.getAttributes().get("firstPlusFour");
		HtmlInputText ssnThreeValue = (HtmlInputText) component.getAttributes().get("ssnThree");
		HtmlInputText ssnTwoValue = (HtmlInputText) component.getAttributes().get("ssnTwo");
		HtmlInputText ssnFourValue = (HtmlInputText) component.getAttributes().get("ssnFour");
		HtmlInputText firstNameValue = (HtmlInputText) component.getAttributes().get("firstName");
		HtmlInputText middleNameValue = (HtmlInputText) component.getAttributes().get("middleName");
		HtmlInputText lastNameValue = (HtmlInputText) component.getAttributes().get("lastName");

		UIInput birthDateValue = (UIInput) component.getAttributes().get("birthDate");

		HtmlInputText mhvIdValue = (HtmlInputText) component.getAttributes().get("mhvId");
		HtmlInputText emailValue = (HtmlInputText) component.getAttributes().get("email");

		if (firstPlusFourValue != null && firstPlusFourValue.getValue() != null) {
			firstPlusFour = (String) firstPlusFourValue.getValue();
		}

		if (ssnThreeValue != null && ssnThreeValue.getValue() != null) {
			ssnThree = (String) ssnThreeValue.getValue();
		}

		if (ssnTwoValue != null && ssnTwoValue.getValue() != null) {
			ssnTwo = (String) ssnTwoValue.getValue();
		}

		if (ssnFourValue != null && ssnFourValue.getValue() != null) {
			ssnFour = (String) ssnFourValue.getValue();
		}

		if (firstNameValue != null && firstNameValue.getValue() != null) {
			firstName = (String) firstNameValue.getValue();
		}

		if (middleNameValue != null && middleNameValue.getValue() != null) {
			middleName = (String) middleNameValue.getValue();
		}

		if (lastNameValue != null && lastNameValue.getValue() != null) {
			lastName = (String) lastNameValue.getValue();
		}

		if (birthDateValue != null && birthDateValue.getValue() != null) {
			birthDate = (Date) birthDateValue.getValue();
		}

		if (mhvIdValue != null && mhvIdValue.getValue() != null) {
			mhvId = (String) mhvIdValue.getValue();
		}

		if (emailValue != null && emailValue.getValue() != null) {
			email = (String) emailValue.getValue();
		}

		// fail validation if certain conditions are not met
		if ((firstPlusFour == null || firstPlusFour.isEmpty()) && (ssnThree == null || ssnThree.isEmpty())
				&& (ssnTwo == null || ssnTwo.isEmpty()) && (ssnFour == null || ssnFour.isEmpty())
				&& (firstName == null || firstName.isEmpty()) && (middleName == null || middleName.isEmpty())
				&& (lastName == null || lastName.isEmpty()) && (mhvId == null || mhvId.isEmpty()) && (birthDate == null)
				&& (email == null || email.isEmpty())) {

			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("userSearchFormCriteriaErrorHeader"), ""));
		}

		if (null != lastName && !lastName.isEmpty() && lastName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("lastNameError"), ""));
		}

		if (null != firstName && !firstName.isEmpty() && firstName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("firstNameError"), ""));
		}

		/*
		 * if (email != null) { Matcher m = emailPattern.matcher(email); if
		 * (!m.matches()) { ResourceBundle bundle =
		 * ResourceBundle.getBundle("labels.messages",
		 * FacesContext.getCurrentInstance().getViewRoot().getLocale()); throw
		 * new ValidatorException( new FacesMessage(FacesMessage.SEVERITY_ERROR,
		 * bundle.getString("invalidEmail"), "")); } }
		 */

		if (firstPlusFour != null) {
			Matcher m = pattern.matcher(firstPlusFour);
			if (!m.matches()) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidForstPlusFourSum"), ""));
			}
		}

		String ssn = "";

		if (ssnThree != null || ssnTwo != null || ssnFour != null) {

			if (ssnThree != null && ssnTwo != null && ssnFour != null) {

				ssn = ssnThree + "-" + ssnTwo + "-" + ssnFour;

			} else if (ssnThree != null && ssnTwo != null && ssnFour == null) {
				ssn = ssnThree + "-" + ssnTwo;
			} else if (ssnThree == null && ssnTwo != null && ssnFour != null) {
				ssn = ssnTwo + "-" + ssnFour;
			} else if (ssnThree == null && ssnTwo == null && ssnFour != null) {
				ssn = ssnFour;
			} else if (ssnThree == null && ssnTwo != null && ssnFour == null) {
				ssn = ssnTwo;
			} else if (ssnThree != null && ssnTwo == null && ssnFour == null) {
				ssn = ssnThree;
			} else if (ssnThree != null && ssnTwo == null && ssnFour != null) {
				ssn = ssnThree + "-" + ssnFour;

			}

			String expression = "^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$";
			Pattern patternSsn = Pattern.compile(expression);
			matcher = patternSsn.matcher(ssn);
			if (!matcher.matches()) {
				String tempSSn = "'" + ssn + "' is not a valid Social Security Number.";
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, tempSSn, ""));
			}

		}
	}

}
